## ----less, include=FALSE----------------------------------------------------------------------------------------------
suppressPackageStartupMessages(library("lessR"))

## ----figs, include=FALSE----------------------------------------------------------------------------------------------
knitr::opts_chunk$set(fig.width=6.0, fig.height=4)

## ----read-------------------------------------------------------------------------------------------------------------
d <- Read("Employee")

## ----labels-----------------------------------------------------------------------------------------------------------
l <- rd("Employee_lbl")

## ---------------------------------------------------------------------------------------------------------------------
l

## ----sp, fig.width=5--------------------------------------------------------------------------------------------------
XY(Years, Salary)

## ----spEnhance, fig.width=5-------------------------------------------------------------------------------------------
XY(Years, Salary, enhance=TRUE)

## ----spaxis, fig.width=5----------------------------------------------------------------------------------------------
XY(Years, Salary, axis_fmt=",", axis_y_prefix="$")

## ----sploess, fig.width=5---------------------------------------------------------------------------------------------
XY(Years, Salary, fit="loess", plot_errors=TRUE)

## ----exp, fig.width=5-------------------------------------------------------------------------------------------------
XY(Years, Salary, fit="exp", plot_errors=TRUE)

## ----size, fig.width=5------------------------------------------------------------------------------------------------
XY(Years, Salary, size=Pre)

## ----three, fig.width=5, fig.height=4---------------------------------------------------------------------------------
XY(c(Pre, Post), Salary, fit="lm", fit_se=0)

## ----carsdata---------------------------------------------------------------------------------------------------------
d <- Read("Cars93")
d$Airbags <- factor(d$Airbags, levels=0:2, labels=c("none", "driver", "drv+pas"))
d$DriveTrain <- factor(d$DriveTrain, levels=0:2, labels=c("rear", "front", "all"))
d$Manual <- factor(d$Manual, levels=0:1, labels=c("Not_Avail", "Available"))

## ----vbs5, fig.width=5, fig.height=6----------------------------------------------------------------------------------
XY(x=MPGhiway, y=HP, by=Airbags, facet=c(DriveTrain, Manual))

## ----spmat, fig.width=4, fig.height=4---------------------------------------------------------------------------------
d <- Read("Employee")
XY(c(Salary, Years, Pre, Post), c(Salary, Years, Pre, Post), fit="lm")

## ----55---------------------------------------------------------------------------------------------------------------
set.seed(13)
x=rnorm(4000)
y= 8*x + rnorm(4000,1, 30)
XY(x, y)

## ----56, fig.width=6.5------------------------------------------------------------------------------------------------
XY(x, y, type="smooth", fit="lm")

## ----57---------------------------------------------------------------------------------------------------------------
XY(x, y, transparency=0.95)

## ----570, fig.width=6.5-----------------------------------------------------------------------------------------------
XY(x, y, type="contour")

## ----58---------------------------------------------------------------------------------------------------------------
XY(x, y, n_bins=5)

## ----x4, fig.height=5, fig.width=5------------------------------------------------------------------------------------
XY(Salary, row_names)

## ----x5, fig.height=5, fig.width=5------------------------------------------------------------------------------------
XY(Salary, row_names, sort="0", segments_y=FALSE)

## ----x6, fig.height=5, fig.width=5.0----------------------------------------------------------------------------------
XY(c(Pre, Post), row_names)

## ----by, fig.width=5--------------------------------------------------------------------------------------------------
XY(Years, Salary, by=Gender)

## ----bycolors, fig.width=6--------------------------------------------------------------------------------------------
XY(Years, Salary, by=Gender, size=2, fit="lm",
     fill=c(M="olivedrab3", W="gold1"), 
     color=c(M="darkgreen", W="gold4")
)

## ----vary, fig.width=6------------------------------------------------------------------------------------------------
XY(Years, Salary, by=Gender, shape="vary")

## ----x, fig.width=5, fig.height=3.5-----------------------------------------------------------------------------------
XY(Years, Salary, facet=Gender, fit="lm")

## ----z----------------------------------------------------------------------------------------------------------------
XY(Salary, Dept)

## ----l, fig.width=5---------------------------------------------------------------------------------------------------
XY(Salary, Dept, by=Gender)

## ---------------------------------------------------------------------------------------------------------------------
d <- Read("Cars93")

## ---------------------------------------------------------------------------------------------------------------------
d$Trans <- factor(d$Manual, levels=0:1, labels=c("Auto", "Manual"))
d$Source <- factor(d$Source, levels=0:1, labels=c("Foreign", "Domestic"))
d$Cylinders <- factor(d$Cylinders, levels=c(4,6,8))

## ----c, fig.height=6, fig.width=5.5-----------------------------------------------------------------------------------
XY(Weight, MPGcity, by=Source, facet=c(Cylinders,Trans), n_axis_x_skip=2, n_row=2)

## ----d, fig.height=3--------------------------------------------------------------------------------------------------
d <- Read("Employee", quiet=TRUE)
XY(Dept, Gender)

## ----e, fig.height=3, fig.width=4.5-----------------------------------------------------------------------------------
XY(Dept, Gender, radius=.6, power=0.8, pad_x=0.05, pad_y=0.05)

