## ----include=FALSE----------------------------------------------------------------------------------------------------
suppressPackageStartupMessages(library("lessR"))

## ----include=FALSE----------------------------------------------------------------------------------------------------
knitr::opts_chunk$set(fig.width=4.5, fig.height=3.5)

## ----read-------------------------------------------------------------------------------------------------------------
d <- Read("Employee")

## ----labels-----------------------------------------------------------------------------------------------------------
l <- rd("Employee_lbl")
l

## ----hsform, dataTable, echo=FALSE, out.width='28%', fig.asp=.7, fig.align='center', out.extra='style="border-style: none"'----
knitr::include_graphics(system.file("img", "hsExplain.png", package="lessR"))

## ----hs, fig.width=4, fig.height=3.5, fig.align='center', fig.cap="Histogram of tablulated counts for the bins of Salary."----
X(Salary)

## ----binwidth, fig.width=4, fig.height=3.5, fig.align='center', fig.cap="Customized histogram."-----------------------
X(Salary, bin_start=35000, bin_width=14000)

## ----colors, fig.width=4, fig.height=3.5, fig.align='center', fig.cap="Customized histogram."-------------------------
X(Salary, fill="reds", color="transparent")

## ----axis, fig.width=4, fig.height=3.5, fig.align='center', fig.cap="Formatted axis values."--------------------------
X(Salary, axis_fmt=",", axis_x_pre="$")

## ----density, fig.width=4, fig.height=3.5, fig.align='center', fig.cap="Histogram with density plot."-----------------
#X(Salary, type="density")

## ----VBS, fig.width=4, fig.height=3.5, fig.align='center', fig.cap="VBS plot."----------------------------------------
X(Salary, type="vbs")

