## ----include=FALSE----------------------------------------------------------------------------------------------------
knitr::opts_chunk$set(fig.width=6.5, fig.height=3)

## ----include=FALSE----------------------------------------------------------------------------------------------------
suppressPackageStartupMessages(library("lessR"))
style(suggest=FALSE)

## ---------------------------------------------------------------------------------------------------------------------
d <- Read("Employee")

## ---------------------------------------------------------------------------------------------------------------------
XY(.Index, Salary)

## ---------------------------------------------------------------------------------------------------------------------
XY(.Index, Salary, size=0, ts_area_fill="on", center_line="off", show_runs=TRUE)

## ---------------------------------------------------------------------------------------------------------------------
d <- Read("StockPrice")
d[1:5,]

## ---------------------------------------------------------------------------------------------------------------------
XY(Month, Price, filter=(Company=="Apple"))

## ---------------------------------------------------------------------------------------------------------------------
XY(Month, Price, filter=(Company=="Apple"), ts_area_fill="on")

## ---------------------------------------------------------------------------------------------------------------------
XY(Month, Price, by=Company)

## ---------------------------------------------------------------------------------------------------------------------
XY(Month, Price, by=Company, ts_stack=TRUE)

## ---------------------------------------------------------------------------------------------------------------------
XY(Month, Price, facet=Company)

## ---------------------------------------------------------------------------------------------------------------------
style(sub_theme="black", window_fill="gray10")
XY(Month, Price, facet=Company, n_col=1, fill="darkred", color="red", trans=.55)

## ---------------------------------------------------------------------------------------------------------------------
style()
style(quiet=TRUE)

## ---------------------------------------------------------------------------------------------------------------------
XY(Month, Price, facet=Company, xlab="", ts_area_fill="on", ts_area_split=25)

## ---------------------------------------------------------------------------------------------------------------------
XY(Month, Price, facet=Company, aspect=.5, ts_area_fill="slategray3")

## ----fig.width=6------------------------------------------------------------------------------------------------------
XY(Month, Price, by=Company, trans=0.4, ts_stack=TRUE, ts_area_fill="emeralds")

## ---------------------------------------------------------------------------------------------------------------------
d <- Read("StockPrice", quiet=TRUE)
XY(Month, Price, ts_unit="quarters", ts_agg="mean", filter=(Company=="Apple"))

## ---------------------------------------------------------------------------------------------------------------------
XY(Month, Price, ts_unit="years", ts_agg="mean", filter=(Company=="Apple"),
     color="darkred")

## ---------------------------------------------------------------------------------------------------------------------
XY(Month, Price, by=Company, ts_unit="years", ts_agg="mean")

## ---------------------------------------------------------------------------------------------------------------------
d <- d[400:473,]
XY(Month, Price, ts_unit="months", ts_agg="mean", ts_ahead=24)

## ---------------------------------------------------------------------------------------------------------------------
XY(Month, Price, ts_unit="months", ts_agg="mean", ts_ahead=24,
     ts_source="classic")

## ---------------------------------------------------------------------------------------------------------------------
XY(Month, Price, ts_unit="months", ts_agg="mean", ts_ahead=24, ts_source="classic", ts_method="lm")

## ---------------------------------------------------------------------------------------------------------------------
XY(Month, Price, ts_unit="months", ts_agg="mean", ts_ahead=24, ts_source="classic", ts_method="lm", ts_seasons="N")

## ---------------------------------------------------------------------------------------------------------------------
STL(Month, Price)

## ---------------------------------------------------------------------------------------------------------------------
set.seed(123)
days <- seq(as.Date("2024-01-01"), as.Date("2024-02-28"), by="day")
sales <- 100 + sin(2 * pi * (1:59) / 7) * 15 + rnorm(59, sd=8)  # Weekly seasonality
d <- data.frame(days, sales)
rm(days); rm(sales)

## ---------------------------------------------------------------------------------------------------------------------
XY(days, sales, ts_ahead=8, ts_unit="days7")

## ---------------------------------------------------------------------------------------------------------------------
d <- read.table(text="
Order.Date    Sales
2021-01-05   19.536
2021-01-06  473.820
2021-01-06    5.480
2021-01-06   12.780
2021-01-06  609.980
2021-01-06   31.120
2021-01-06    6.540
2021-01-06   19.440
2021-01-07  176.728
2021-01-07   10.430
2021-01-09    9.344
2021-01-09   31.200
2021-01-10   51.940
2021-01-10    2.890",
header = TRUE)

## ---------------------------------------------------------------------------------------------------------------------
XY(Order.Date, Sales, ts_unit="days")

## ---------------------------------------------------------------------------------------------------------------------
new_row <- data.frame(
  Order.Date = "2021-01-08",
  Sales = NA
)
d <- rbind(d, new_row)
d <- order_by(d, by=Order.Date)
d[9:12,]

## ---------------------------------------------------------------------------------------------------------------------
XY(Order.Date, Sales, ts_unit="days")

## ---------------------------------------------------------------------------------------------------------------------
XY(Order.Date, Sales, ts_unit="days", ts_NA=0)

## ---------------------------------------------------------------------------------------------------------------------
d <- Read("StockPrice", quiet=TRUE)
head(d)

## ---------------------------------------------------------------------------------------------------------------------
dw <- reshape_wide(d, widen=Company, response=Price, ID=Month)
head(dw)

## ---------------------------------------------------------------------------------------------------------------------
a1.ts <- ts(dw$Apple, frequency=12, start=c(1980, 12))
XY(a1.ts)

## ---------------------------------------------------------------------------------------------------------------------
style()

## ----fig.width=4.5----------------------------------------------------------------------------------------------------
d <- Read("StockPrice")
x <- as.Date("2007-06-01")
XY(Month, Price, filter=(Company == "Apple"), ts_area_fill="on",
            add=c("iPhone", "arrow"),
            x1=c(x,x), y1=c(100,90), x2=x, y2=30)

