## ----include=FALSE----------------------------------------------------------------------------------------------------
suppressPackageStartupMessages(library("lessR"))
suppressPackageStartupMessages(library("kableExtra"))

## ----include=FALSE----------------------------------------------------------------------------------------------------
knitr::opts_chunk$set(fig.width=3.5, fig.height=3)

## ----dataTable, echo=FALSE, out.width='65%', fig.asp=.7, fig.align='center', fig.cap="Structure of a data table."-----
knitr::include_graphics(system.file("img", "DataTable.png", package="lessR"))

## ---------------------------------------------------------------------------------------------------------------------
library(knitr)
library(kableExtra)

# Create the data frame with multiple extensions in the same row
data <- data.frame(
  Extension = c(".csv<br>.tsv<br>.prn<br>.txt", 
                ".xls<br>.xlsx", 
                ".ods", 
                ".feather<br>.parquet", 
                ".rda", 
                ".sav, .zsav<br>.dta<br>.sas7bdat"
               ),
  Format = c("text, custom separator and decimal<br>
             text, tab separated values<br> 
             text, space separated values<br> 
             text, comma or tab separated",
             "Excel", 
             "ODS", 
             "feather<br>parquet", 
             "R", 
             "SPSS<br>Stata<br>SAS"
            ),
  Package = c("R utils", "openxlsx", "readODS", "arrow", "R base", "haven"
             ),
  Source = c("read.csv( )<br>read.delim( )<br>read.table( )<br>read.table( )<br>",
             "read.xlsx( )<br>", "read_ODS( )",
             "read_feather( )<br>read_parquet( )",
             "load( )",
             "read_spss( )<br>read_sas( )<br>read_stata( )"
            )
)

knitr::kable(data, format="html", escape=FALSE,
             caption="`lessR` `Read()` and `Write()` available data file formats.") |>
  kableExtra::kable_styling("striped") |>
  column_spec(1, background = rgb(236,243,249, maxColorValue=255)) # Col 1

## ----rline, fig.align='center', fig.cap="Output of Read()."-----------------------------------------------------------
d <- Read("Employee")

## ----brief, fig.align='center', fig.cap="Output of Read()."-----------------------------------------------------------
d <- Read("Employee", brief=FALSE)

## ---------------------------------------------------------------------------------------------------------------------
l <- Read("Employee_lbl", var_labels=TRUE)

## ---------------------------------------------------------------------------------------------------------------------
library(knitr)
library(kableExtra)

# Create the data frame with multiple extensions in the same row
data <- data.frame(
  Extension = c(".txt<br>.csv<br>.tsv<br>.prn", 
                ".xlsx", 
                ".ods", 
                ".feather", 
                ".parquet", 
                ".rda", 
                ".sav"),
  Format = c("text, custom separator and decimal<br>
             text, comma separated values<br> 
             text, tab separated values<br> 
             text, space separated values", 
             "Excel", 
             "ODS", 
             "feather", 
             "parquet", 
             "R", 
             "SPSS"), 
  Package = c("R utils", "openxlsx", "readODS", "arrow", "arrow", "R base",
              "haven"),
  Function = c("write.table( )<br>write.csv( )<br>write.delim( )<br>&nbsp;",
               "write.xlsx( )<br>", "write_ods( )",
               "write_feather( )", "write_parquet( )",
               "load( )", "write_sav( )")
)

# Create the formatted table with a light blue first column
knitr::kable(data, format="html", escape=FALSE,
             caption="`lessR` `Read()` and `Write()` data file formats.") |>
  kableExtra::kable_styling("striped") |>
  column_spec(1, background = rgb(236,243,249, maxColorValue=255))  # Light blue background for first column

