## ----include=FALSE----------------------------------------------------------------------------------------------------
knitr::opts_chunk$set(fig.width=5, fig.height=3)

## ----include=FALSE----------------------------------------------------------------------------------------------------
suppressPackageStartupMessages(library("lessR"))

## ---------------------------------------------------------------------------------------------------------------------
style(quiet=TRUE)

## ---------------------------------------------------------------------------------------------------------------------
getColors("hues")

## ----echo=FALSE-------------------------------------------------------------------------------------------------------
getColors("hues", output=TRUE)

## ----fig.height=6, fig.width=6----------------------------------------------------------------------------------------
getColors(n=36, shape="wheel", border="off")

## ----echo=FALSE, fig.height=6, fig.width=6----------------------------------------------------------------------------
getColors(n=36, shape="wheel", border="off", output=TRUE)

## ---------------------------------------------------------------------------------------------------------------------
getColors(c=50, l=30)

## ----echo=FALSE-------------------------------------------------------------------------------------------------------
getColors(c=50, l=30, output=TRUE)

## ---------------------------------------------------------------------------------------------------------------------
d <- Read("Employee", quiet=TRUE)
Chart(Dept, fill=getColors(c=50, l=30), quiet=TRUE)

## ---------------------------------------------------------------------------------------------------------------------
myColors <- getColors(c=90, l=80, n=5)
Chart(Dept, fill=myColors, labels_color="gray20", quiet=TRUE)

## ---------------------------------------------------------------------------------------------------------------------
#showPalettes()

## ---------------------------------------------------------------------------------------------------------------------
getColors("blues")

## ----echo=FALSE-------------------------------------------------------------------------------------------------------
getColors("blues", output=TRUE)

## ---------------------------------------------------------------------------------------------------------------------
getColors("blues", c=60, l=c(30,80))

## ----echo=FALSE-------------------------------------------------------------------------------------------------------
getColors("blues", c=60, l=c(30,80), output=TRUE)

## ---------------------------------------------------------------------------------------------------------------------
getColors("browns", c=c(20,90), l=60)

## ----echo=FALSE-------------------------------------------------------------------------------------------------------
getColors("browns", c=c(20,90), l=60, output=TRUE)

## ----fig.width=6------------------------------------------------------------------------------------------------------
d2 <- Read("StockPrice", quiet=TRUE)
Plot(Month, Price, by=Company, ts_stack=TRUE, ts_area_fill="reds", trans=0.4, data=d2)

## ---------------------------------------------------------------------------------------------------------------------
getColors("rusts", "blues")

## ----echo=FALSE-------------------------------------------------------------------------------------------------------
getColors("rusts", "blues", output=TRUE)

## ---------------------------------------------------------------------------------------------------------------------
getColors("rusts", "blues", c=75)

## ----echo=FALSE-------------------------------------------------------------------------------------------------------
getColors("rusts", "blues", c=75, output=TRUE)

## ---------------------------------------------------------------------------------------------------------------------
getColors("viridis")

## ----echo=FALSE-------------------------------------------------------------------------------------------------------
getColors("viridis", output=TRUE)

## ---------------------------------------------------------------------------------------------------------------------
getColors("Royal1")

## ----echo=FALSE-------------------------------------------------------------------------------------------------------
getColors("Royal1", output=TRUE)

## ---------------------------------------------------------------------------------------------------------------------
getColors("distinct")

## ----echo=FALSE-------------------------------------------------------------------------------------------------------
getColors("distinct", output=TRUE)

## ---------------------------------------------------------------------------------------------------------------------
values <- c(rep(1,2), rep(2,5), rep(3,4), rep(4,3), rep(5,6), rep(6,7), rep(7,8))
Responses <- sample(values, size=100, replace=TRUE)

LikertCats <- c("Strongly Disagree", "Disagree", "Slightly Disagree",
                "Neutral", "Slightly Agree", "Agree", "Strongly Agree")
Responses <- factor(Responses, levels=1:7, labels=LikertCats)

## ---------------------------------------------------------------------------------------------------------------------
red <- getColors("reds", n=3, c=c(75,35), l=c(27,63))
blue <- getColors("blues", n=3)

## ---------------------------------------------------------------------------------------------------------------------
Chart(Responses, fill=c(red, "gray50", blue))

## ---------------------------------------------------------------------------------------------------------------------
d <- Read("Employee")

## ---------------------------------------------------------------------------------------------------------------------
style("gray")
Chart(Dept)

## ---------------------------------------------------------------------------------------------------------------------
style("darkred")
Chart(Dept, quiet=TRUE)

## ----fig.height=6-----------------------------------------------------------------------------------------------------
X(Salary, facet=Dept, quiet=TRUE)

## ---------------------------------------------------------------------------------------------------------------------
style(window_fill="aliceblue")
Chart(Dept, theme="sienna")

## ---------------------------------------------------------------------------------------------------------------------
style(show=TRUE)

## ----echo=FALSE-------------------------------------------------------------------------------------------------------
style()

