## ----include=FALSE------------------------------------------------------------
suppressPackageStartupMessages(library("lessR"))

## ----include=FALSE------------------------------------------------------------
knitr::opts_chunk$set(fig.width=4.5, fig.height=3)

## ----read---------------------------------------------------------------------
d <- Read("Employee")

## ----labels-------------------------------------------------------------------
l <- rd("Employee_lbl")
l

## ----f1-----------------------------------------------------------------------
Chart(Dept, filter=(Gender=="W"))

## ----f1hr2--------------------------------------------------------------------
Chart(Dept, filter=c(1:5, 20,21))

## ----bc1, dataTable, echo=FALSE, out.width='28%', fig.asp=.7, fig.align='center', out.extra='style="border-style: none"'----
knitr::include_graphics(system.file("img", "bcExplain.png", package="lessR"))

## ----bcEx, fig.width=4, fig.height=3.5, fig.align='center', fig.cap="Bar chart of tablulated counts of employees in each department."----
Chart(Dept)

## ---------------------------------------------------------------------------------------------------------------------
style(quiet=TRUE)

## ----fig.width=4, fig.height=3.75, fig.align='center'-----------------------------------------------------------------
Chart(Dept, fill="darkred", color="black", transparency=.8,
         labels_color="black")

## ----fig.width=4, fig.height=3.5, fig.align='center'------------------------------------------------------------------
Chart(Dept, theme="gray", labels="off", horiz=TRUE)

## ----fig.width=4, fig.height=3.5, fig.align='center'------------------------------------------------------------------
Chart(Dept, fill="reds")

## ----fig.width=4, fig.height=3.5, fig.align='center'------------------------------------------------------------------
Chart(Dept, fill="viridis")

## ----fig.width=4, fig.height=3.5, fig.align='center'------------------------------------------------------------------
Chart(Dept, fill="GrandBudapest1")

## ----fig.width=4, fig.height=3.5, fig.align='center'------------------------------------------------------------------
Chart(Dept, fill=(count))

## ----fig.width=4, fig.height=3.5, fig.align='center'------------------------------------------------------------------
Chart(Dept, rotate_x=45, offset=1, sort="-")

## ----fig.width=4, fig.height=3.5, fig.align='center'------------------------------------------------------------------
Chart(Dept, axis_fmt=",", axis_y_pre="£")

## ----a----------------------------------------------------------------------------------------------------------------
a <- pivot(d, mean, Salary, Dept)
a

## ----bcXY, dataTable, echo=FALSE, out.width='35%', fig.asp=.7, fig.align='center', out.extra='style="border-style: none"'----
knitr::include_graphics(system.file("img", "bcXYExplain.png", package="lessR"))

## ----xy, fig.width=4, fig.height=3.5, fig.align='center'--------------------------------------------------------------
Chart(Dept, y=Salary_mean, data=a)

## ----fig.width=4, fig.height=3.5, fig.align='center'------------------------------------------------------------------
Chart(Dept, y=Salary, stat="dev", sort="+", fill_split=0)

## ----fig.width=4, fig.height=3.5, fig.align='center'------------------------------------------------------------------
Chart(Dept, y=Salary, stat="deviation", sort="+",
         fill_scaled=TRUE, fill=c("red", "blue"))

## ----barstack, fig.width=6, fig.height=5.5, fig.align='center'--------------------------------------------------------
d <- Read("Mach4", quiet=TRUE)
Chart(m01:m20, horiz=TRUE, labels="off", sort="+")

## ----BPFM, fig.width=6, fig.height=5.5, fig.align='center'------------------------------------------------------------
Chart(m01:m20, type="bubble")

## ----fig.width=4, fig.height=3.5, fig.align='center'------------------------------------------------------------------
d <- Read("Employee", quiet=TRUE)
style(add_fill="aliceblue")
Chart(Dept, add=c("rect", "Employees by\nDepartment"),
                     x1=c(1.75,3), y1=c(11, 10), x2=4.25, y2=9)

## ----echo=FALSE, include=FALSE----------------------------------------------------------------------------------------
d <- Read("Employee")

## ----pc1, fig.align='center', fig.width=3.5, fig.height=3.5-----------------------------------------------------------
Chart(Dept, type="pie")

## ----hole0, fig.width=3.5, fig.height=3.5, fig.align='center', fig.cap="Standard pie chart of variable Dept in the _d_ data frame."----
Chart(Dept, hole=0, type="pie", quiet=TRUE)

## ----bc2var, dataTable, echo=FALSE, out.width='34%', fig.asp=.7, fig.align='center', out.extra='style="border-style: none"'----
knitr::include_graphics(system.file("img", "bc2Explain.png", package="lessR"))

## ----fig.width=4, fig.align='center'----------------------------------------------------------------------------------
Chart(Dept, by=Gender)

## ----fig.width=4, fig.align='center'----------------------------------------------------------------------------------
Chart(Dept, by=Gender, fill=c("deepskyblue", "black"))

## ----fig.width=5, fig.align='center'----------------------------------------------------------------------------------
Chart(Dept, by=Gender, beside=TRUE, labels_position="out")

## ----fig.width=6------------------------------------------------------------------------------------------------------
Chart(Gender, by=Dept, horiz=TRUE)

## ----fig.width=4, fig.align='center'----------------------------------------------------------------------------------
Chart(Dept, facet=Gender)

## ----fig.align='center'-----------------------------------------------------------------------------------------------
Chart(Dept, facet=Gender, n_col=1)

## ----fig.width=4, fig.align='center'----------------------------------------------------------------------------------
Chart(Dept, by=Gender, stack100=TRUE)

## ---------------------------------------------------------------------------------------------------------------------
d <- rd("Mach4", quiet=TRUE)

## ---------------------------------------------------------------------------------------------------------------------
l <- rd("Mach4_lbl", quiet=TRUE)

## ---------------------------------------------------------------------------------------------------------------------
LikertCats <- c("Strongly Disagree", "Disagree", "Slightly Disagree",
                     "Slightly Agree", "Agree", "Strongly Agree")
d <- factors(c(m06,m07,m09,m10), levels=0:5, labels=LikertCats, ordered=TRUE)

## ----fig.width=6, fig.height=4.5, fig.align='center'------------------------------------------------------------------
Chart(m06, by=m07, quiet=FALSE)

